# London Hotel Website - Booking Form Setup Instructions

## Overview
Your booking form now uses **Formspree** - a simple service that handles form submissions and sends emails directly to your inbox. No server setup required!

## Quick Setup (5 minutes)

### Step 1: Create Formspree Account
1. Go to [https://formspree.io](https://formspree.io)
2. Sign up for a free account using your email
3. The free plan allows 50 submissions per month (perfect for a hotel)

### Step 2: Create Your Form
1. After signing up, click "New Form"
2. Enter your email: `bookings@londonhotel.co.tz`
3. Give it a name: "London Hotel Bookings"
4. Copy the form endpoint URL (looks like: `https://formspree.io/f/xyzabc123`)

**Note**: The form is already configured to use `bookingform@londonhotel.co.tz` as the sender address for professional email delivery.

### Step 3: Update Your Website
1. Open `booking.html` in a text editor
2. Find this line (around line 85):
   ```html
   <form id="booking-form" action="https://formspree.io/f/bookings@londonhotel.co.tz" method="POST">
   ```
3. Replace `https://formspree.io/f/bookings@londonhotel.co.tz` with your actual Formspree endpoint URL

### Step 4: Upload Your Website
Upload all files to your web hosting and you're done!

## How It Works

1. **Customer fills form** → All booking details captured
2. **Clicks submit** → Form data sent to Formspree
3. **Formspree processes** → Sends formatted email to bookings@londonhotel.co.tz
4. **Customer sees success page** → Professional confirmation message
5. **You receive email** → All booking details in your inbox

## Features Included

✅ **Direct Email Sending** - No email client opening, sends directly
✅ **Spam Protection** - Google reCAPTCHA included (test version)
✅ **Professional Layout** - Clean, mobile-friendly design
✅ **Success Page** - Customers see confirmation after submission
✅ **Email Formatting** - Booking details nicely formatted in email
✅ **Form Validation** - Required fields and date validation

## Optional: Custom reCAPTCHA (Advanced)

The form includes a test reCAPTCHA. For production:
1. Go to [https://www.google.com/recaptcha](https://www.google.com/recaptcha)
2. Create a new site
3. Get your site key
4. Replace `6LeIxAcTAAAAAJcZVRqyHh71UMIEGNQ_MXjiZKhI` in booking.html with your site key

## Support

- **Formspree Support**: [https://help.formspree.io](https://help.formspree.io)
- **Free Plan**: 50 submissions/month
- **Paid Plans**: Start at $10/month for unlimited submissions

## Email Template

When customers submit the form, you'll receive emails like this:

```
From: bookingform@londonhotel.co.tz
To: bookings@londonhotel.co.tz
Subject: New Booking Request - London Hotel

firstName: John
lastName: Doe
email: john@example.com
phone: +255 123 456789
checkin: 2024-12-25
checkout: 2024-12-27
guests: 2
rooms: 1
requests: Late check-in please
```

The emails will appear to come from `bookingform@londonhotel.co.tz` making them look professional and helping with email delivery.

That's it! Your booking form will work immediately after setup.

