# London Hotel Website - Complete Package

## Overview
This is a complete hotel website for London Hotel built with HTML, CSS, JavaScript, Bootstrap, and PHP. The website includes direct email functionality for booking requests without any third-party dependencies.

## Features
✅ **Responsive Design** - Works perfectly on desktop, tablet, and mobile
✅ **Direct Email Sending** - PHP-powered booking form sends emails directly
✅ **Professional Layout** - Modern Bootstrap design with custom styling
✅ **Image Gallery** - Showcases hotel photos and videos
✅ **Contact Forms** - Both booking and general contact functionality
✅ **SEO Friendly** - Optimized for search engines
✅ **Fast Loading** - Optimized images and clean code

## Technologies Used
- **HTML5** - Semantic markup
- **CSS3** - Custom styling with Bootstrap 5.3.2
- **JavaScript** - Form validation and interactivity
- **PHP** - Server-side email processing
- **Bootstrap Icons** - Professional iconography

## Installation Instructions for cPanel

### 1. Upload Files
1. Download and extract the website package
2. Upload all files to your cPanel File Manager
3. Place files in the `public_html` directory (or subdirectory)

### 2. PHP Configuration
The website requires PHP 7.4 or higher. Most cPanel hosting providers support this by default.

**Important**: Ensure your hosting supports the PHP `mail()` function for email sending.

### 3. Email Configuration
The booking form sends emails to: `bookings@londonhotel.co.tz`
From address: `bookingform@londonhotel.co.tz`

**Make sure these email addresses exist in your cPanel:**
1. Go to cPanel → Email Accounts
2. Create `bookings@londonhotel.co.tz` 
3. Create `bookingform@londonhotel.co.tz`

### 4. File Permissions
Ensure the following file has write permissions for logging:
- `booking_logs.txt` (will be created automatically)

### 5. Test the Website
1. Visit your website URL
2. Navigate to the Booking page
3. Fill out and submit the form
4. Check your email for booking notifications

## File Structure
```
london-hotel-website/
├── index.html              # Homepage
├── about.html              # About Us page
├── rooms.html              # Rooms & Rates page
├── bar-restaurant.html     # Bar & Restaurant page
├── gallery.html            # Photo gallery
├── booking.html            # Booking form
├── booking-success.html    # Success confirmation
├── contact.html            # Contact page
├── process_booking.php     # PHP email handler
├── css/
│   └── style.css          # Custom styles
├── js/
│   └── main.js            # JavaScript functionality
├── images/                # Hotel photos and logos
└── README.md              # This file
```

## Booking Form Features
- **Real-time Validation** - Checks dates, required fields
- **AJAX Submission** - No page reload required
- **Professional Emails** - HTML formatted booking notifications
- **Cost Calculation** - Automatic total calculation
- **Success Feedback** - User-friendly confirmation messages

## Email Template
When customers submit bookings, you'll receive professionally formatted HTML emails with:
- Guest contact information
- Booking details (dates, rooms, guests)
- Cost calculations
- Special requests
- Submission timestamp

## Customization
To modify content:
1. **Text Content** - Edit HTML files directly
2. **Styling** - Modify `css/style.css`
3. **Images** - Replace files in `images/` directory
4. **Email Settings** - Edit `process_booking.php`

## Support
For technical issues:
1. Check PHP error logs in cPanel
2. Verify email account setup
3. Test form submission
4. Contact your hosting provider for PHP mail() support

## Security Notes
- Form data is sanitized and validated
- HTML special characters are escaped
- Email headers are properly formatted
- Input validation prevents common attacks

## Browser Compatibility
- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Mobile browsers

---

**London Hotel Website** - Professional, responsive, and ready for production use.

